/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.remotesupport.inconn;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.remotesupport.inconn.InboundConnectivityBean;
import com.ibm.hsc.remotesupport.inconn.InboundConnectivityConstants;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigData;
import com.ibm.hwmca.fw.rcs.inconn.InboundConfigManager;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorData;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class InboundConnectivityTasklet
extends PanelTasklet
implements InboundConnectivityConstants {
    private static final String TRACE_MASKT = "JRCSICTT";
    private static final String TRACE_MASKF = "JRCSICTF";
    private static final String TRACE_MASKD = "JRCSICTD";
    private static final ClassLogInfo classLogInfo = new ClassLogInfo(-88, -124, "RCS-IConTskl");
    private InboundConnectivityBean inboundConnBean;
    private InboundConfigData inboundConfigData;
    private static final String DFC_RCSINCONFIG_ID = "rcsinconncfg";
    private static final String METHODS_PREFIX = "methods_";

    public InboundConnectivityTasklet() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> InboundConnectivityTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> init()");
        Trace.trace((String)TRACE_MASKT, (Object)"<- init()");
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        block16: {
            Trace.trace((String)TRACE_MASKT, (Object)("-> service(" + panelTaskletRequest + ", " + panelTaskletResponse + ")"));
            try {
                if (panelTaskletRequest.isInitialRequest()) {
                    DisplayAreaDescriptorDelegate[] displayAreaDescriptorDelegateArray;
                    this.inboundConnBean = new InboundConnectivityBean();
                    this.inboundConnBean.setBeanName("InboundConnectivityBean");
                    InboundConfigManager inboundConfigManager = InboundConfigManager.getInboundConfigManager();
                    this.inboundConfigData = inboundConfigManager.getInboundConfig();
                    DisplayAreaDescriptorData displayAreaDescriptorData = new DisplayAreaDescriptorData("com.ibm.hsc.remotesupport.inconn.res.InboundConnRes2", "InboundConnectivityPanel", (PanelBean)this.inboundConnBean, null, null);
                    ArrayList<DisplayAreaDescriptorDelegate> arrayList = new ArrayList<DisplayAreaDescriptorDelegate>();
                    try {
                        displayAreaDescriptorDelegateArray = BaseFileControl.getFilePath((String)DFC_RCSINCONFIG_ID);
                        Trace.trace((String)TRACE_MASKF, (Object)("Config path=" + (String)displayAreaDescriptorDelegateArray));
                        File[] fileArray = new File((String)displayAreaDescriptorDelegateArray).listFiles(new MethodsFileFilter());
                        if (fileArray.length >= 1) {
                            Trace.trace((String)TRACE_MASKF, (Object)("Methods config file=" + fileArray[0]));
                            ConfigXmlHandler configXmlHandler = new ConfigXmlHandler();
                            List list = configXmlHandler.parseInConnXML(new FileReader(fileArray[0]));
                            Iterator iterator = list.iterator();
                            while (iterator.hasNext()) {
                                MethodData methodData = (MethodData)iterator.next();
                                Trace.trace((String)TRACE_MASKF, (Object)methodData);
                                DisplayAreaDescriptorDelegate displayAreaDescriptorDelegate = new DisplayAreaDescriptorDelegate(methodData.taskletClass, null);
                                displayAreaDescriptorDelegate.setMountPoint("ConnectivityMethodsTPane");
                                arrayList.add(displayAreaDescriptorDelegate);
                            }
                        } else {
                            String string = "No inbound connectivity methods configured in " + (String)displayAreaDescriptorDelegateArray;
                            Trace.trace((String)TRACE_MASKF, (Object)string);
                            AusMicrocodeLog ausMicrocodeLog = new AusMicrocodeLog(classLogInfo, 0);
                            ausMicrocodeLog.add(string);
                            ausMicrocodeLog.writeEntry(null);
                        }
                    }
                    catch (Exception exception) {
                        new AusMicrocodeLog(classLogInfo, 0, exception).writeEntry(null);
                    }
                    displayAreaDescriptorDelegateArray = arrayList.toArray(new DisplayAreaDescriptorDelegate[arrayList.size()]);
                    panelTaskletResponse.replace(displayAreaDescriptorData, (DisplayAreaDescriptor[])displayAreaDescriptorDelegateArray);
                    break block16;
                }
                if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
                    panelTaskletResponse.terminate();
                } else {
                    String string = (String)panelTaskletRequest.getData("Source");
                    if (string == null) {
                        string = "";
                    }
                    Trace.trace((String)TRACE_MASKF, (Object)("source=" + string));
                    if (string.equals("")) {
                        Trace.trace((String)TRACE_MASKF, (Object)"Unspecified source");
                        panelTaskletResponse.noAction();
                    } else if (string.equals("InboundConnectivityPanel")) {
                        this.serviceInboundConnectivityPanel(panelTaskletRequest, panelTaskletResponse);
                    } else {
                        Trace.trace((String)TRACE_MASKF, (Object)"Unknown source");
                        panelTaskletResponse.noAction();
                    }
                }
            }
            catch (TaskletException taskletException) {
                throw taskletException;
            }
            catch (Exception exception) {
                throw new TaskletException((Throwable)exception);
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKT, (Object)("-> logException(" + throwable + ")"));
        new AusMicrocodeLog(classLogInfo, 4, throwable).writeEntry(null);
        Trace.trace((String)TRACE_MASKT, (Object)"<- logException()");
    }

    private void serviceInboundConnectivityPanel(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> serviceInboundConnectivityPanel()");
        String string = (String)panelTaskletRequest.getData("Command");
        if (string == null) {
            string = "";
        }
        Trace.trace((String)TRACE_MASKF, (Object)("command=" + string));
        if (string.equals("")) {
            Trace.trace((String)TRACE_MASKF, (Object)"Unspecified command");
            panelTaskletResponse.noAction();
        } else if (string.equals("Commit")) {
            InboundConnectivityBean inboundConnectivityBean = (InboundConnectivityBean)panelTaskletRequest.getData("Bean");
            if (inboundConnectivityBean != null) {
                // empty if block
            }
            InboundConfigManager inboundConfigManager = InboundConfigManager.getInboundConfigManager();
            inboundConfigManager.setInboundConfig(this.inboundConfigData);
            panelTaskletResponse.terminate();
        } else if (string.equals("Cancel")) {
            panelTaskletResponse.terminate();
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"Unknown command");
            panelTaskletResponse.noAction();
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- serviceInboundConnectivityPanel()");
    }

    public InboundConfigData getInboundConfigData() {
        return this.inboundConfigData;
    }

    class ConfigXmlHandler
    extends DefaultHandler {
        private static final String ELEMENT_INBOUND_CONNECTIVITY = "InboundConnectivity";
        private static final String ELEMENT_METHOD = "Method";
        private static final String ELEMENT_TASKLET_CLASS = "TaskletClass";
        private XMLReader xmlReader = new SAXParser();
        private StringBuffer chars = new StringBuffer();
        private List methods;
        private MethodData methodData;

        public ConfigXmlHandler() {
            this.xmlReader.setContentHandler(this);
            this.xmlReader.setErrorHandler(this);
        }

        public synchronized List parseInConnXML(Reader reader) throws IOException, SAXException {
            this.xmlReader.setFeature("http://xml.org/sax/features/validation", true);
            this.xmlReader.parse(new InputSource(reader));
            return this.methods;
        }

        public void startDocument() throws SAXException {
            this.chars.setLength(0);
            this.methods = new ArrayList();
        }

        public void endDocument() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (string2.equals(ELEMENT_METHOD)) {
                this.methodData = new MethodData();
            }
            this.chars.setLength(0);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (string2.equals(ELEMENT_METHOD)) {
                this.methods.add(this.methodData);
            } else if (string2.equals(ELEMENT_TASKLET_CLASS)) {
                this.methodData.taskletClass = this.chars.toString();
            }
            this.chars.setLength(0);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.chars.append(cArray, n, n2);
        }
    }

    class MethodData {
        String taskletClass = null;

        MethodData() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[MethodData: taskletClass=" + this.taskletClass + "]");
            return stringBuffer.toString();
        }
    }

    class MethodsFileFilter
    implements FilenameFilter {
        MethodsFileFilter() {
        }

        public boolean accept(File file, String string) {
            return string.startsWith(InboundConnectivityTasklet.METHODS_PREFIX);
        }
    }
}

